<?php

namespace App\Http\Controllers;

use App\Http\Requests\StorePartner;
use App\Http\Requests\UpdatePartner;
use App\Models\Partner;
use Illuminate\Http\Request;
use Illuminate\Support\Facades\File;
use Input;
use DB;
use Session;

class PartnerController extends Controller
{
    public function viewPartner()
    {
        $data = DB::table('partners')->get();
        return view('dashboards.admins.partners.index', ['data' => $data]);
    }

    public function editPartner($id)
    {
        $singledata = DB::table('partners')->where('id', $id)->first();
        if($singledata == NULL){
            return redirect('admin/viewpartner');
        }
        $data = DB::table('partners')->get();
        return view('dashboards.admins.partners.edit', ['data' => $data, 'singledata' => $singledata]);
    }

    public function insertData(StorePartner $request)
    {
        $file = $request->file('ptpicture');
        $ptimg = time().'_'.$file->getClientOriginalName();
        $file->move(public_path().'/partner-images/', $ptimg);

        $data = Partner::create([
            'ptname' => request('ptname'),
            'slug' => request('slug'),
            'ptpicture' => $ptimg,
            'status' => request('status'),
            'remark' => request('remark'),
        ]);
        session::flash('message', 'Data Inserted Successfully!');
        return redirect()->back();
    }

    public function updateData(UpdatePartner $request, $id)
    {
        $data = Partner::find($id);

        if($request->hasFile('ptpicture')) {
           $file = $request->file('ptpicture');
            $ptimg = time().'_'.$file->getClientOriginalName();
            $file->move(public_path().'/partner-images/', $ptimg);

            $oldFilename = $data->ptpicture;
            //update the database
            $data->ptpicture = $ptimg;
            //delete the old file
            File::delete(public_path().'/partner-images/'.$oldFilename);
        }

        $data->ptname = $request->input('ptname');
        $data->slug = $request->input('slug');
        $data->status = $request->input('status');
        $data->remark = $request->input('remark');
        $data->save();

        // $data->update($request->all());
        session::flash('message', 'Data Updated Successfully!');
        return redirect()->back();
    }

    public function multipleDelete()
    {
        $data = Input::except('_token');
        if($data['bulk-action'] == 0){
            session::flash('message', 'Please select the action you want to perform');
            return redirect()->back();
        }
        $tbl = decrypt($data['tbl']);
        $tblid = decrypt($data['tblid']);
        if(empty($data['select-data'])){
            session::flash('message', 'Please select the data you want to delete');
            return redirect()->back();
        }
        $ids = $data['select-data'];
        // print_r($ids);
        foreach ($ids as $id) {
            DB::table($tbl)->where($tblid, $id)->delete();
        }
        session::flash('message', 'Data deleted Successfully!');
            return redirect()->back();
    }
}
