<?php

namespace App\Http\Controllers;

use App\Models\User;
use App\Models\Department;
use Illuminate\Http\Request;
use Spatie\Permission\Models\Role;
use App\Http\Requests\UpdateProfile;
use Illuminate\Support\Facades\Hash;
use App\Http\Requests\UpdateEmployee;
use Illuminate\Support\Facades\Storage;

class ProfileController extends Controller
{
    public function profile()
    {
        if(!auth()->user()->can('view_profile')) {
            abort(403, 'Unauthorized Action');
        }

        $employee = auth()->user();
        return view('dashboards.admins.profile.profile', compact('employee'));
    }

    public function editprofile($id)
    {
        if(!auth()->user()->can('edit_profile')) {
            abort(403, 'Unauthorized Action');
        }

        $employee = User::findOrFail(auth()->user()->id);
        $old_roles = $employee->roles->pluck('id')->toArray();
        $departments = Department::orderBy('title')->get();
        $roles = Role::all();
        return view('dashboards.admins.profile.editprofile', compact('employee', 'old_roles', 'departments', 'roles'));
    }

}
