<?php

namespace App\Http\Controllers;

use Carbon\Carbon;
use App\Models\ServiceA;
use Illuminate\Http\Request;
use Yajra\Datatables\Datatables;
use Spatie\Permission\Models\Role;
use App\Http\Requests\StoreServiceA;
use App\Http\Requests\UpdateServiceA;
use Illuminate\Support\Facades\Storage;

class ServiceAController extends Controller
{
    public function index()
    {
        if(!auth()->user()->can('view_service_area')) {
            abort(403, 'Unauthorized Action');
        }
        return view('dashboards.admins.servicea.index');
    }

    public function ssd(Request $request)
    {
        if(!auth()->user()->can('view_service_area')) {
            abort(403, 'Unauthorized Action');
        }

        $servicea = ServiceA::all();

        return Datatables::of($servicea)
            ->editColumn('picture', function($each) {
                return '<img src="' . $each->servicea_path() . '" class="profile-thumbnail" alt=""/>';
            })
            ->editColumn('updated_at', function($each) {
                return Carbon::parse($each->updated_at)->format('Y-m-d H:i:s');
            })
            ->addColumn('action', function($each) {
                $edit_icon = '<a href="' . route('servicearea.edit', $each->id) . '" class="text-warning"><i class="far fa-edit"></i></a>';
                $info_icon = '<a href="' . route('servicearea.show', $each->id) . '" class="text-primary"><i class="fas fa-info-circle"></i></a>';
                $delete_icon = '<a href="#" class="text-danger delete-btn" data-id="'. $each->id .'"><i class="fas fa-trash-alt"></i></a>';

                return '<div class="action-icon">' . $edit_icon . $info_icon . $delete_icon.'</div>';
            })
            ->addColumn('plus-icon', function($each) {
                return null;
            })
            ->rawColumns(['action', 'picture'])
            ->make(true);
    }

    public function create()
    {
        if(!auth()->user()->can('create_service_area')) {
            abort(403, 'Unauthorized Action');
        }

        return view('dashboards.admins.servicea.create');
    }

    public function store(StoreServiceA $request)
    {
        if(!auth()->user()->can('create_service_area')) {
            abort(403, 'Unauthorized Action');
        }

        $picture = null;
        if($request->hasFile('picture')) {
            $picture = $request->file('picture');
            $picture_name = uniqid(). '_' . time() . '.' . $picture->getClientOriginalExtension();
            Storage::disk('public')->put('servicearea/' . $picture_name, file_get_contents($picture));
        }
        $slug = uniqid();
        $servicea = new ServiceA();
        $servicea->name = $request->name;
        $servicea->slug = $slug;
        $servicea->description = $request->description;
        $servicea->address = $request->address;
        $servicea->phone1 = $request->phone1;
        $servicea->phone2 = $request->phone2;
        $servicea->phone3 = $request->phone3;
        $servicea->picture = $picture_name;
        $servicea->maplink = $request->maplink;
        $servicea->save();

        return redirect()->route('servicearea.index')->with('create', 'Service area is successfully Create!');
    }

    public function edit($id)
    {
        if(!auth()->user()->can('edit_service_area')) {
            abort(403, 'Unauthorized Action');
        }

        $servicea = ServiceA::findOrFail($id);

        return view('dashboards.admins.servicea.edit', compact('servicea'));
    }
    public function update($id, UpdateServiceA $request)
    {
        if(!auth()->user()->can('edit_service_area')) {
            abort(403, 'Unauthorized Action');
        }

        $servicea = ServiceA::findOrFail($id);

        $picture_name = $servicea->picture;
        if($request->hasFile('picture')) {

            Storage::disk('public')->delete('servicearea/' . $servicea->picture);

            $picture = $request->file('picture');
            $picture_name = uniqid(). '_' . time() . '.' . $picture->getClientOriginalExtension();
            Storage::disk('public')->put('servicearea/'. $picture_name, file_get_contents($picture));
        }

        $servicea->name = $request->name;
        $servicea->description = $request->description;
        $servicea->address = $request->address;
        $servicea->phone1 = $request->phone1;
        $servicea->phone2 = $request->phone2;
        $servicea->phone3 = $request->phone3;
        $servicea->picture = $picture_name;
        $servicea->maplink = $request->maplink;
        $servicea->update();


        return redirect()->route('servicearea.index')->with('update', 'Service Area is successfully Update!');
    }

    public function show($id)
    {
        if(!auth()->user()->can('view_service_area')) {
            abort(403, 'Unauthorized Action');
        }
        $servicea = ServiceA::findOrFail($id);
        return view('dashboards.admins.servicea.show', compact('servicea'));
    }

    public function destroy($id)
    {
        if(!auth()->user()->can('delete_service_area')) {
            abort(403, 'Unauthorized Action');
        }
        $servicea = ServiceA::findOrFail($id);
        $servicea->delete();

        return 'success';
    }
}
