<!DOCTYPE html>
<html lang="en">
<head>
  <meta charset="utf-8">
  <meta name="viewport" content="width=device-width, initial-scale=1">
  <!-- CSRF Token -->
  <meta name="csrf-token" content="{{ csrf_token() }}">

  <title>NCSC | Register</title>
  <link rel="shortcut icon" href="{{{ asset('img/favicon.png') }}}">

  <!-- Font Awesome -->
  <link rel="stylesheet" href="{{ asset('back/plugins/fontawesome-free/css/all.min.css') }}">
  <!-- icheck bootstrap -->
  <link rel="stylesheet" href="{{ asset('back/plugins/icheck-bootstrap/icheck-bootstrap.min.css') }}">
  <!-- Theme style -->
  <link rel="stylesheet" href="{{ asset('back/dist/css/adminlte.css') }}">
  <style>
    .reg {
      position: absolute;
      top: 25px;
    }
    .card {
      background: rgba(255,255,255, 0.5);
        box-shadow: 0 3px 6px rgba(0,0,0,.16),0 3px 6px rgba(0,0,0,.23)!important;
    }
    #particles-js1 {
      width: 100%;
      background: #eef6ff;
      height: 100vh;
    }
  </style>
</head>
<body class="hold-transition">
  <div id="particles-js1">
    <div class="container">
      <div class="row">
        <div class="col-md-6 offset-md-4">
          <div class="reg">
            <div class="register-box">
              <!-- /.login-logo -->
              <img src="{{ asset('img/nebacklogo.png') }}" class="img-fluid mb-3 mx-auto d-block" style="width: 150px; height: 130px; margin-top: -10px;">
              <div class="card card-outline card-primary">
                <div class="card-header text-center">
                  <a href="{{url('/') }}" class="h1" style="color: #000;"><b>NCSC</b></a>
                </div>
                <div class="card-body">
                  <!-- <p class="login-box-msg">Register a new membership</p> -->

                  <form method="POST" action="{{ route('register') }}">
                    @if ( Session::get('success'))
                    <div class="alert alert-success">
                     {{ Session::get('success') }}
                   </div>
                   @endif
                   @if ( Session::get('error'))
                   <div class="alert alert-danger">
                     {{ Session::get('error') }}
                   </div>
                   @endif
                   @csrf
                   <div class="input-group mb-3">
                    <input id="name" type="text" class="form-control @error('name') is-invalid @enderror" name="name" value="{{ old('name') }}" required autocomplete="name" autofocus placeholder="Name">

                    @error('name')
                    <span class="invalid-feedback" role="alert">
                      <strong>{{ $message }}</strong>
                    </span>
                    @enderror
                    <div class="input-group-append">
                      <div class="input-group-text">
                        <span class="fas fa-user"></span>
                      </div>
                    </div>
                  </div>
                  <div class="input-group mb-3">
                    <input id="email" type="email" class="form-control @error('email') is-invalid @enderror" name="email" value="{{ old('email') }}" required autocomplete="email" placeholder="Email">

                    @error('email')
                    <span class="invalid-feedback" role="alert">
                      <strong>{{ $message }}</strong>
                    </span>
                    @enderror
                    <div class="input-group-append">
                      <div class="input-group-text">
                        <span class="fas fa-envelope"></span>
                      </div>
                    </div>
                  </div>
                  <!-- <div class="input-group mb-3">
                      <?php $dept=getdept(); ?>
                      <select name="dept" id="" class="form-control">
                        @foreach($dept as $depts)
                        <option value='{{ $depts }}'>{{ $depts }}</option>
                        @endforeach
                      </select>
                  
                    <div class="input-group-append">
                      <div class="input-group-text">
                        <span class="far fa-building"></span>
                      </div>
                    </div>
                  </div> -->
                  <div class="input-group mb-3">
                    <input id="password" type="password" class="form-control @error('password') is-invalid @enderror" name="password" required autocomplete="new-password" placeholder="Password">

                    @error('password')
                    <span class="invalid-feedback" role="alert">
                      <strong>{{ $message }}</strong>
                    </span>
                    @enderror
                    <div class="input-group-append">
                      <div class="input-group-text">
                        <span class="fas fa-lock"></span>
                      </div>
                    </div>
                  </div>
                  <div class="input-group mb-3">
                    <input id="password-confirm" type="password" class="form-control" name="password_confirmation" required autocomplete="new-password" placeholder="Confirm Password">
                    <div class="input-group-append">
                      <div class="input-group-text">
                        <span class="fas fa-lock"></span>
                      </div>
                    </div>
                  </div>
                  <div class="row">
                    <div class="col-8">
                      <!-- <div class="icheck-primary">
                        <input type="checkbox" id="agreeTerms" name="terms" value="agree">
                        <label for="agreeTerms">
                         I agree to the <a href="#">terms</a>
                       </label>
                     </div> -->
                   </div>
                   <!-- /.col -->
                   <div class="col-4">
                    <button type="submit" class="btn btn-primary btn-block">Register</button>
                  </div>
                  <!-- /.col -->
                </div>
              </form>

                <!-- <div class="social-auth-links text-center">
                  <a href="#" class="btn btn-block btn-primary">
                    <i class="fab fa-facebook mr-2"></i>
                    Sign up using Facebook
                  </a>
                  <a href="#" class="btn btn-block btn-danger">
                    <i class="fab fa-google-plus mr-2"></i>
                    Sign up using Google+
                  </a>
                </div> -->

                <a href="{{route('login')}}" class="text-center" style="color: #000;">I already have a membership</a>
              </div>
              <!-- /.form-box -->
            </div><!-- /.card -->
          </div>
          <!-- /.register-box -->
          </div>
        </div>
      </div>
    </div>
  </div>

<!-- jQuery -->
<script src="{{ asset('back/plugins/jquery/jquery.min.js') }}"></script>
<!-- Bootstrap 4 -->
<script src="{{ asset('back/plugins/bootstrap/js/bootstrap.bundle.min.js') }}"></script>
<!-- AdminLTE App -->
<script src="{{ asset('back/dist/js/adminlte.min.js') }}"></script>
<!-- <script src="{{ asset('back/dist/js/particles.min.js') }}"></script> -->
<script type="text/javascript">
  /* ---- particles.js config ---- */

  // particlesJS("particles-js1", {
  //   particles: {
  //     number: { value: 120, density: { enable: true, value_area: 800 } },
  //     color: { value: "#ffffff" },
  //     shape: {
  //       type: "circle",
  //       stroke: { width: 2, color: "#000000" },
  //       polygon: { nb_sides: 5 },
  //       image: { src: "img/github.svg", width: 100, height: 100 }
  //     },
  //     opacity: {
  //       value: 0.5,
  //       random: false,
  //       anim: { enable: false, speed: 1, opacity_min: 0.1, sync: false }
  //     },
  //     size: {
  //       value: 7,
  //       random: true,
  //       anim: { enable: false, speed: 40, size_min: 0.1, sync: false }
  //     },
  //     line_linked: {
  //       enable: true,
  //       distance: 150,
  //       color: "#00f6ff",
  //       opacity: 0.4,
  //       width: 2
  //     },
  //     move: {
  //       enable: true,
  //       speed: 3,
  //       direction: "none",
  //       random: false,
  //       straight: false,
  //       out_mode: "out",
  //       bounce: false,
  //       attract: { enable: false, rotateX: 600, rotateY: 1200 }
  //     }
  //   },
  //   interactivity: {
  //     detect_on: "canvas",
  //     events: {
  //       onhover: { enable: true, mode: "repulse" },
  //       onclick: { enable: true, mode: "push" },
  //       resize: true
  //     },
  //     modes: {
  //       grab: { distance: 400, line_linked: { opacity: 1 } },
  //       bubble: { distance: 400, size: 40, duration: 2, opacity: 8, speed: 3 },
  //       repulse: { distance: 200, duration: 0.4 },
  //       push: { particles_nb: 4 },
  //       remove: { particles_nb: 2 }
  //     }
  //   },
  //   retina_detect: true
  // });
  // var count_particles, stats, update;
  // stats = new Stats();
  // stats.setMode(0);
  // stats.domElement.style.position = "absolute";
  // stats.domElement.style.left = "0px";
  // stats.domElement.style.top = "0px";
  // document.body.appendChild(stats.domElement);
  // count_particles = document.querySelector(".js-count-particles");
  // update = function () {
  //   stats.begin();
  //   stats.end();
  //   if (window.pJSDom[0].pJS.particles && window.pJSDom[0].pJS.particles.array) {
  //     count_particles.innerText = window.pJSDom[0].pJS.particles.array.length;
  //   }
  //   requestAnimationFrame(update);
  // };
  // requestAnimationFrame(update);
</script>
</body>
</html>
