@extends('dashboards.admins.layouts.admin-dash-layout')
@section('title', 'Create Blog')

@section('content')
<!-- Content Header (Page header) -->
    <section class="content-header">
        <div class="container-fluid">
            <div class="row mb-2">
                <div class="col-sm-6">
                    <h5>Create Blog</h5>
                </div>

            </div>
        </div><!-- /.container-fluid -->
    </section>

    <!-- Main content -->
    <section class="content">
        <div class="container-fluid">
            <div class="row">
                <div class="col-12">
    <div class="card">
        <div class="card-body">
            <form id="create-form" action="{{ route('blog.store') }}" method="POST" enctype="multipart/form-data">
                @csrf
                <div class="md-form">
                    <label for="">Title</label>
                    <input type="text" name="title" class="form-control">
                </div>
                <div class="md-form">
                    <label for="">Content</label>
                    <textarea name="description" id="" class="form-control"></textarea>
                </div>

                <div class="form-group">
                    <label for="">Categories</label>
                    <select name="blogcategories[]" class="form-control select-ninja" multiple>
                        @foreach ($category as $c)
                            <option value="{{ $c->id }}">{{ $c->name }}</option>
                        @endforeach
                    </select>
                </div>



                <div class="form-group">
                    <label for="profile_img">Feature Image</label>
                    <input type="file" name="picture" id="picture" class="form-control p-1">
                    <div class="preview_img my-2">

                    </div>
                </div>

                <div class="md-form">
                    <label>Status</label>
                    <select class="form-control" name="status">
                        <option>Public</option>
                        <option>Draft</option>
                    </select>
                </div>



                <div class="d-flex justify-content-center mt-5 mb-3">
                    <div class="col-md-6">
                        <button type="submit" class="btn btn-primary btn-sm btn-block">Comfirm</button>
                    </div>
                </div>
            </form>
        </div>
    </div>
                </div></div></div></section>
@endsection
@section('scripts')
    {!! JsValidator::formRequest('App\Http\Requests\StoreBlog', '#create-form'); !!}
    <script src="{{ asset('ckeditor/ckeditor.js') }}"></script>
                {{--  <script src="https://cdn.ckeditor.com/4.17.2/standard-all/ckeditor.js"></script>  --}}
    <script>
        $(document).ready(function(){
            var editor = CKEDITOR.replace('description', {

                filebrowserBrowseUrl: '../../editor/ckfinder/ckfinder.html',
                filebrowserImageBrowseUrl: '../../editor/ckfinder/ckfinder.html?type=Images',
                filebrowserFlashBrowseUrl: '../../editor/ckfinder/ckfinder.html?type=Flash',
                filebrowserUploadUrl: '../../editor/ckfinder/core/connector/php/connector.php?command=QuickUpload&type=Files',
                filebrowserImageUploadUrl: '../../editor/ckfinder/core/connector/php/connector.php?command=QuickUpload&type=Images',
                filebrowserFlashUploadUrl: '../../editor/ckfinder/core/connector/php/connector.php?command=QuickUpload&type=Flash',
                extraPlugins: 'emoji',
            });

            $('#picture').on('change', function() {
                var file_lenght = document.getElementById('picture').files.length;
                $('.preview_img').html('');
                for (var i = 0; i < file_lenght; i++) {
                    $('.preview_img').append(`<img src="${URL.createObjectURL(event.target.files[i])}"/>`);
                }
            });
        });
    </script>

@endsection
