<?php

use Illuminate\Support\Facades\Auth;
use Illuminate\Support\Facades\Route;
use App\Http\Controllers\DcController;
use App\Http\Controllers\KcController;
use App\Http\Controllers\KlController;
use App\Http\Controllers\PlController;
use App\Http\Controllers\SdController;

use App\Http\Controllers\BlogController;


// for user
use App\Http\Controllers\HomeController;

// for sulabbpaing
use App\Http\Controllers\LandController;
use App\Http\Controllers\PlanController;
use App\Http\Controllers\RoleController;
use App\Http\Controllers\UserController;
use App\Http\Controllers\AdminController;

// for knowledge
use App\Http\Controllers\NuserController;
use App\Http\Controllers\EditorController;
// for Donate
use App\Http\Controllers\ProfileController;
use App\Http\Controllers\user\LfController;

use App\Http\Controllers\CategoryController;
use App\Http\Controllers\EmployeeController;
use App\Http\Controllers\ServiceAController;
use App\Http\Controllers\user\KlfController;

use App\Http\Controllers\user\SdfController;
use App\Http\Controllers\DepartmentController;
use App\Http\Controllers\PermissionController;
use App\Http\Controllers\user\FrontController;
use App\Http\Controllers\BlogCategoryController;
use App\Http\Controllers\user\BlogFrontController;
use App\Http\Controllers\LaController; //အကျယ်အဝန်း
use App\Http\Controllers\LtaController; //အရပ်လှည့်
use App\Http\Controllers\LtController; //မြေအမျိုးအစား
use App\Http\Controllers\user\ServiceAFrontController;
use App\Http\Controllers\TsController; //မြို့နယ် ၈ မြို့နယ်
/*
|--------------------------------------------------------------------------
| Web Routes
|--------------------------------------------------------------------------
|
| Here is where you can register web routes for your application. These
| routes are loaded by the RouteServiceProvider within a group which
| contains the "web" middleware group. Now create something great!
|
*/


Route::get('/', [FrontController::class, 'index'])->name('/');

Auth::routes();

// Route::get('/home', [HomeController::class, 'index'])->name('home');
Route::group(['prefix' => 'laravel-filemanager', 'middleware' => ['web', 'auth']], function (){
    \UniSharp\LaravelFilemanager\Lfm::routes();
});


Route::get('/sulabbpaing-lands', [LfController::class, 'index'])->name('sulabbpaing-lands.index');
Route::get('/sulabbpaing-lands/township/{slug}', [LfController::class, 'townshipbylands'])->name('sulabbpaing-lands.townshipbylands');
Route::get('/sulabbpaing-lands/landtype/{slug}', [LfController::class, 'typebylands'])->name('sulabbpaing-lands.typebylands');
Route::get('/sulabbpaing-lands/price/{slug}', [LfController::class, 'pricebylands'])->name('sulabbpaing-lands.pricebylands');

Route::get('/sulabbpaing-lands/{slug}', [LfController::class, 'show'])->name('sulabbpaing-lands.show');

Route::post('/sulabbpaing-lands/search', [LfController::class, 'search'])->name('sulabbpaing-lands.search');

Route::get('/sulabbpaing-knowledge-blog', [KlfController::class, 'index'])->name('sulabbpaing-knowledge-blog.index');
Route::get('/sulabbpaing-knowledge-blog/category/{slug}', [KlfController::class, 'categorybyknowledges'])->name('sulabbpaing-knowledge-blog.categorybyknowledges');

Route::get('/sulabbpaing-knowledge-blog/{slug}', [KlfController::class, 'show'])->name('sulabbpaing-knowledge-blog.show');

Route::get('/sulabbpaing-donate-blog', [SdfController::class, 'index'])->name('sulabbpaing-donate-blog.index');
Route::get('/sulabbpaing-donate-blog/location/{slug}', [SdfController::class, 'locationbydonate'])->name('sulabbpaing-donate-blog.locationbydonate');

Route::get('/sulabbpaing-donate-blog/{slug}', [SdfController::class, 'show'])->name('sulabbpaing-donate-blog.show');

Route::get('sulabbpaing-about', [FrontController::class, 'about'])->name('about');
Route::get('sulabbpaing-contact', [FrontController::class, 'contact'])->name('contact');

Route::get('/t-linkblog', [BlogFrontController::class, 'index'])->name('t-linkblog.index');
Route::get('/t-link-category-blog/{slug}', [BlogFrontController::class, 'categorybyblog'])->name('t-linkblog.categorybyblog');
Route::post('/t-link-search-blog', [BlogFrontController::class, 'search'])->name('t-linkblog.search');

Route::get('/t-linkblog/{slug}', [BlogFrontController::class, 'show'])->name('t-linkblog.show');

Route::get('/t-link-service-area/{slug}', [ServiceAFrontController::class, 'show'])->name('t-link-service-area.show');
Route::group([ 'prefix' => 'admin', 'middleware' => ['auth'] ], function () {

    Route::resource('employee', \App\Http\Controllers\EmployeeController::class);
    Route::get('/employee/datatable/ssd', [EmployeeController::class, 'ssd']);

    Route::get('/userinfo', [ProfileController::class, 'profile'])->name('admin.profileinfo');
    Route::get('/userinfo/{id}', [ProfileController::class,'editprofile'])->name('admin.editprofile');
    Route::post('/userinfo/{id}', [ProfileController::class,'updateprofile'])->name('admin.updateprofile');


    Route::resource('role', \App\Http\Controllers\RoleController::class);
    Route::get('/role/datatable/ssd', [RoleController::class, 'ssd']);

    Route::resource('permission', \App\Http\Controllers\PermissionController::class);
    Route::get('/permission/datatable/ssd', [PermissionController::class, 'ssd']);

    Route::resource('servicearea', \App\Http\Controllers\ServiceAController::class);
    Route::get('/servicearea/datatable/ssd', [ServiceAController::class, 'ssd']);

    Route::resource('plan', \App\Http\Controllers\PlanController::class);
    Route::get('/plan/datatable/ssd', [PlanController::class, 'ssd']);

    Route::resource('blog', \App\Http\Controllers\BlogController::class);
    Route::get('/blog/datatable/ssd', [BlogController::class, 'ssd']);

    Route::resource('blogcategory', \App\Http\Controllers\BlogCategoryController::class);
    Route::get('/blogcategory/datatable/ssd', [BlogCategoryController::class, 'ssd']);

    Route::resource('department', \App\Http\Controllers\DepartmentController::class);
    Route::get('/department/datatable/ssd', [DepartmentController::class, 'ssd']);

	Route::get('dashboard',[AdminController::class,'index'])->name('admin.dashboard');
    Route::get('profile',[AdminController::class,'profile'])->name('admin.profile');
    Route::get('settings',[AdminController::class,'settings'])->name('admin.settings');

	Route::post('update-profile-info',[AdminController::class,'updateInfo'])->name('adminUpdateInfo');
	Route::post('change-profile-picture',[AdminController::class,'updatePicture'])->name('adminPictureUpdate');
	Route::post('change-password',[AdminController::class,'changePassword'])->name('adminChangePassword');


    // Route::get('view-ne-partner', [PartnerController::class, 'viewPartner'])->name('admin.ne-partner');
	// Route::post('add-ne-partner', [PartnerController::class, 'insertData']);
	// Route::get('edit-ne-partner/{id}', [PartnerController::class, 'editPartner'])->name('admin.edit-ne-partner');
	// Route::post('update-ne-partner/{id}', [PartnerController::class, 'updateData']);
	// Route::post('multipledelete', [PartnerController::class, 'multipleDelete']);

	// for sulabbpaing
	Route::get('viewLt', [LtController::class, 'viewLt'])->name('admin.Lt');
	Route::post('addlt', [LtController::class, 'insertData']);
	Route::get('editLt/{id}', [LtController::class, 'editLt'])->name('admin.editLt');
	Route::post('updatelt/{id}', [LtController::class, 'updateData']);
	Route::post('multipledelete', [LtController::class, 'multipleDelete']);

    Route::get('viewPl', [PlController::class, 'viewPl'])->name('admin.Pl');
	Route::post('addpl', [PlController::class, 'insertData']);
	Route::get('editPl/{id}', [PlController::class, 'editPl'])->name('admin.editPl');
	Route::post('updatepl/{id}', [PlController::class, 'updateData']);
	Route::post('multipledelete', [PlController::class, 'multipleDelete']);

	Route::get('viewLta', [LtaController::class, 'viewLta'])->name('admin.Lta');
	Route::post('addlta', [LtaController::class, 'insertData']);
	Route::get('editLta/{id}', [LtaController::class, 'editLta'])->name('admin.editLta');
	Route::post('updatelta/{id}', [LtaController::class, 'updateData']);
	Route::post('multipledelete', [LtaController::class, 'multipleDelete']);

	Route::get('viewLa', [LaController::class, 'viewLa'])->name('admin.La');
	Route::post('addla', [LaController::class, 'insertData']);
	Route::get('editLa/{id}', [LaController::class, 'editLa'])->name('admin.editLa');
	Route::post('updatela/{id}', [LaController::class, 'updateData']);
	Route::post('multipledelete', [LaController::class, 'multipleDelete']);

	Route::get('viewTs', [TsController::class, 'viewTs'])->name('admin.Ts');
	Route::post('addts', [TsController::class, 'insertData']);
	Route::get('editTs/{id}', [TsController::class, 'editTs'])->name('admin.editTs');
	Route::post('updatets/{id}', [TsController::class, 'updateData']);
	Route::post('multipledelete', [TsController::class, 'multipleDelete']);

	Route::resource('lands', \App\Http\Controllers\LandController::class);
    // Route::post('lands-delete', [LandController::class, 'destroy'])->name('admin.lands-delete');

	//land edit blade images delete
	Route::post('landimages/delete', [LandController::class, 'fileDelete']);

	// for knowledge section
	// knowledge category
	Route::get('viewKc', [KcController::class, 'viewKc'])->name('admin.Kc');
	Route::post('addkc', [KcController::class, 'insertData']);
	Route::get('editKc/{id}', [KcController::class, 'editKc'])->name('admin.editKc');
	Route::post('updatekc/{id}', [KcController::class, 'updateData']);
	Route::post('multipledelete', [KcController::class, 'multipleDelete']);
	// knowledge page
	Route::get('knowledges', [KlController::class, 'index'])->name('knowledges.index');
	Route::get('add-knowledge', [KlController::class, 'create']);
	Route::post('k-store', [KlController::class, 'store']);
	Route::get('edit-knowledge/{id}', [KlController::class, 'edit']);
	Route::post('k-update/{id}', [KlController::class, 'updateData']);
	Route::post('klmultipledelete', [KlController::class, 'multipleDelete']);

	// Donate page
	Route::get('donates', [SdController::class, 'index'])->name('donates.index');
	Route::get('add-sd', [SdController::class, 'create']);
	Route::post('sd-store', [SdController::class, 'store']);
	Route::get('edit-sd/{id}', [SdController::class, 'edit']);
	Route::post('sd-update/{id}', [SdController::class, 'updateData']);
	Route::post('sdmultipledelete', [SdController::class, 'multipleDelete']);

	// donate category
	Route::get('viewDc', [DcController::class, 'viewDc'])->name('admin.Dc');
	Route::post('adddc', [DcController::class, 'insertData']);
	Route::get('editDc/{id}', [DcController::class, 'editDc'])->name('admin.editDc');
	Route::post('updatedc/{id}', [DcController::class, 'updateData']);
	Route::post('multipledelete', [DcController::class, 'multipleDelete']);
});

