<?php $__env->startSection('title', 'Blog'); ?>

<?php $__env->startSection('content'); ?>


    <!-- ======= Breadcrumbs ======= -->
    <section id="breadcrumbs" class="breadcrumbs">
        <div class="container">

            <ol>
                <li><a href="<?php echo e(route('/')); ?>">Home</a></li>
                <li><a href="<?php echo e(route('t-linkblog.index')); ?>">Blog</a></li>
            </ol>
            <h4><?php echo e($blog->title); ?></h4>

        </div>
    </section><!-- End Breadcrumbs -->

    <div class="container my-3">
        <div class="row t-linkblog">
            <div class="col-md-8">
                <img src="<?php echo e($blog->blogimage_path()); ?>" alt="" class="img-fluid img-thumbnail">

                <h5 class="mt-2"><?php echo e($blog->title); ?></h5>
                <span>
                    <i class="bi bi-person"></i> <a href="#"><?php echo e($blog->user->name); ?></a>
                    <i class="bi bi-clock"></i> <a href="#"><?php echo e($blog->created_at->format('j F, Y')); ?></a>
                </span>
                <p><?php echo $blog->description; ?></p>

                <div class="mb-2">
                    <i class="bi bi-tags"></i>
                    <ul class="tags">
                    <?php $__currentLoopData = $blog->blogcategories; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $bc): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
                        <li><a href="<?php echo e(route('t-linkblog.categorybyblog', $bc->slug)); ?>"><?php echo e($bc->name); ?></a></li>
                    <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
                    </ul>
                </div>

            </div>
            <div class="col-md-4">
                <div class="sidebar">

                    <h3 class="sidebar-title">Search</h3>
                    <div class="sidebar-item search-form">
                        <form action="<?php echo e(route('t-linkblog.search')); ?>" method="post">
                            <?php echo csrf_field(); ?>
                            <input type="text" name="s">
                            <button type="submit"><i class="bi bi-search"></i></button>
                        </form>
                    </div><!-- End sidebar search formn-->

                    <h3 class="sidebar-title">Categories</h3>
                    <div class="sidebar-item categories">
                        <ul>
                            <?php $__empty_1 = true; $__currentLoopData = $blogcategories; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $bc): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); $__empty_1 = false; ?>
                                <?php if($bc->blogs->count() == 0): ?>
                                <?php else: ?>
                                    <li><a href="<?php echo e(route('t-linkblog.categorybyblog', $bc->slug)); ?>"><?php echo e($bc->name); ?> <span>(<?php echo e($bc->blogs()->count()); ?>)</span></a>
                                    </li>
                                <?php endif; ?>
                            <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); if ($__empty_1): ?>
                                <li>No Category Found!</li>
                            <?php endif; ?>

                        </ul>
                    </div><!-- End sidebar categories-->

                    <h3 class="sidebar-title">Recent Posts</h3>
                    <div class="sidebar-item recent-posts">
                        <?php $__empty_1 = true; $__currentLoopData = $latestblogs; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $lblog): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); $__empty_1 = false; ?>
                            <div class="post-item clearfix">
                                <img src="<?php echo e($lblog->blogimage_path()); ?>" alt="" class="img-fluid">
                                <h4><a href="<?php echo e(route('t-linkblog.show', $lblog->slug)); ?>"><?php echo e($lblog->title); ?></a></h4>
                                <time datetime="2020-01-01">Jan 1, 2020</time>
                            </div>
                        <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); if ($__empty_1): ?>
                            <p>No Latest Blog found!</p>
                        <?php endif; ?>

                    </div><!-- End sidebar recent posts-->

                </div><!-- End sidebar -->
            </div>
        </div>
    </div>

<?php $__env->stopSection(); ?>

<?php echo $__env->make('dashboards.guest.layouts.guest_layout1', \Illuminate\Support\Arr::except(get_defined_vars(), ['__data', '__path']))->render(); ?><?php /**PATH C:\xampp\htdocs\tlinkftth\resources\views/dashboards/guest/blog/show.blade.php ENDPATH**/ ?>