<?php $__env->startSection('title', 'Edit Service Area'); ?>

<?php $__env->startSection('content'); ?>
    <!-- Content Header (Page header) -->
    <section class="content-header">
        <div class="container-fluid">
            <div class="row mb-2">
                <div class="col-sm-6">
                    <h5>Edit Service Area</h5>
                </div>

            </div>
        </div><!-- /.container-fluid -->
    </section>

    <!-- Main content -->
    <section class="content">
        <div class="container-fluid">
            <div class="row">
                <div class="col-12">
                    <div class="card">
                        <div class="card-body">
                            <form id="edit-form" action="<?php echo e(route('servicearea.update', $servicea->id)); ?>" method="POST"
                                enctype="multipart/form-data">
                                <?php echo csrf_field(); ?>
                                <?php echo method_field('PUT'); ?>
                                <div class="md-form">
                                    <label for="">Name</label>
                                    <input type="text" name="name" value="<?php echo e($servicea->name); ?>" class="form-control">
                                </div>

                                <div class="md-form">
                                    <label for="">Description</label>
                                    <textarea name="description" id=""
                                        class="md-textarea form-control"><?php echo e($servicea->description); ?></textarea>
                                </div>

                                <div class="md-form">
                                    <label for="">Address</label>
                                    <textarea name="address" id=""
                                        class="md-textarea form-control"><?php echo e($servicea->address); ?></textarea>
                                </div>

                                <div class="md-form">
                                    <label for="">Phone One</label>
                                    <input type="number" name="phone1" value="<?php echo e($servicea->phone1); ?>"
                                        class="form-control">
                                </div>

                                <div class="md-form">
                                    <label for="">Phone Two</label>
                                    <input type="number" name="phone2" value="<?php echo e($servicea->phone2); ?>"
                                        class="form-control">
                                </div>
                                <div class="md-form">
                                    <label for="">Phone Three</label>
                                    <input type="number" name="phone3" value="<?php echo e($servicea->phone3); ?>"
                                        class="form-control">
                                </div>

                                <div class="form-group">
                                    <label for="profile_img">Feature Image</label>
                                    <input type="file" name="picture" id="picture" class="form-control p-1">
                                    <div class="preview_img my-2">
                                        <?php if($servicea->picture): ?>
                                            <img src="<?php echo e($servicea->servicea_path()); ?>" alt="">
                                        <?php endif; ?>
                                    </div>
                                </div>

                                <div class="md-form">
                                    <label for="">Map Link</label>
                                    <textarea name="maplink" id=""
                                        class="md-textarea form-control"><?php echo e($servicea->maplink); ?></textarea>
                                </div>

                                <div class="d-flex justify-content-center mt-5 mb-3">
                                    <div class="col-md-6">
                                        <button type="submit" class="btn btn-primary btn-sm btn-block">Comfirm</button>
                                    </div>
                                </div>
                            </form>
                        </div>
                    </div>
                </div>
            </div>
        </div>
    </section>
<?php $__env->stopSection(); ?>
<?php $__env->startSection('scripts'); ?>
    <?php echo JsValidator::formRequest('App\Http\Requests\UpdateServiceA', '#edit-form'); ?>

    <script>
        $(document).ready(function() {
            $('#picture').on('change', function() {
                var file_lenght = document.getElementById('picture').files.length;
                $('.preview_img').html('');
                for (var i = 0; i < file_lenght; i++) {
                    $('.preview_img').append(`<img src="${URL.createObjectURL(event.target.files[i])}"/>`);
                }
            });
        });
    </script>

<?php $__env->stopSection(); ?>

<?php echo $__env->make('dashboards.admins.layouts.admin-dash-layout', \Illuminate\Support\Arr::except(get_defined_vars(), ['__data', '__path']))->render(); ?><?php /**PATH C:\xampp\htdocs\tlinkftth\resources\views/dashboards/admins/servicea/edit.blade.php ENDPATH**/ ?>